#include <amxmodx>
#include <dhudmessage>

#define MIN_AFK_TIME 30		// I use this incase stupid admins accidentally set mp_afktime to something silly.
#define WARNING_TIME 15		// Start warning the user this many seconds before they are about to be kicked.
#define CHECK_FREQ 5		// This is also the warning message frequency.

new g_oldangles[33][3]
new g_afktime[33]
new bool:g_spawned[33] = {true, ...}
new cvar_afk_time, cvar_afk_minplayers, cvar_afk_kickmsg, cvar_afk_immunity

public plugin_init() 
{
	register_plugin("AFK Kicker by Leo_[BH]", "2.0", "Leo_[BH] / Cheesy Peteza") 
	
	register_dictionary("afkkicker_leo.txt") 

	cvar_afk_time = register_cvar("afk_time", "90") // Kick people AFK longer than this time
	cvar_afk_minplayers = register_cvar("afk_minplayers", "10") // Only kick AFKs when there is atleast this many players on the server
	cvar_afk_immunity = register_cvar("afk_immunity", "a")
	cvar_afk_kickmsg = register_cvar("afk_msg_kick", "1")
	
	set_task(float(CHECK_FREQ),"checkPlayers",_,_,_,"b")
	register_event("ResetHUD", "playerSpawned", "be")
}

public checkPlayers() 
{
	for (new i = 1; i <= get_maxplayers(); i++) 
	{
		if (is_user_alive(i) && is_user_connected(i) && !is_user_bot(i) && !is_user_hltv(i) && g_spawned[i]) 
		{
			new flags[24]
			get_pcvar_string(cvar_afk_immunity, flags, charsmax(flags))
			new immunity = read_flags(flags)
			
			if(get_user_flags(i) & immunity ) 
			{
				continue;
			}
			
			new newangle[3]
			get_user_origin(i, newangle)

			if ( newangle[0] == g_oldangles[i][0] && newangle[1] == g_oldangles[i][1] && newangle[2] == g_oldangles[i][2] ) 
			{
				g_afktime[i] += CHECK_FREQ
				check_afktime(i)
			} 
			else 
			{
				g_oldangles[i][0] = newangle[0]
				g_oldangles[i][1] = newangle[1]
				g_oldangles[i][2] = newangle[2]
				g_afktime[i] = 0
			}
		}
	}
}

check_afktime(id) 
{
	new numplayers = get_playersnum()
	new minplayers = get_pcvar_num(cvar_afk_minplayers)
	
	if (numplayers >= minplayers) 
	{
		new maxafktime = get_pcvar_num(cvar_afk_time)
		
		if (maxafktime < MIN_AFK_TIME) 
		{
			log_amx("cvar mp_afktime %i is too low. Minimum value is %i.", maxafktime, MIN_AFK_TIME)
			maxafktime = MIN_AFK_TIME
			set_cvar_num("mp_afktime", MIN_AFK_TIME)
		}

		if ( maxafktime-WARNING_TIME <= g_afktime[id] < maxafktime) 
		{
			new timeleft = maxafktime - g_afktime[id]
			client_print(id, print_chat, "%L %L", id, "AFK_PREFIX", id, "AFK_WARN_CHAT", timeleft)
			set_dhudmessage(224, 224, 0, -1.0, 0.75, 2, 6.0, 2.0, 0.03, 1.0); 			// // // // //    HUD    // // // // //
			show_dhudmessage(id, "%L", id, "AFK_WARN_HUD", timeleft); 					// // // // //    HUD    // // // // //
		}
		else if (g_afktime[id] > maxafktime) 
		{
			if(get_pcvar_num(cvar_afk_kickmsg)) 
			{
				new name[32]
				get_user_name(id, name, 31)
				client_print(0, print_chat, "%L %L", id, "AFK_PREFIX", id, "AFK_MSG_CHAT_KICK", name, maxafktime)
			}
			
			server_cmd("kick #%d ^"%L^" ", get_user_userid(id), id, "AFK_KICK_REASON", maxafktime)
		}
	}
}

// // // // // // // // // // // // // // //

public client_connect(id) 
{
	g_afktime[id] = 0
}

public client_putinserver(id) 
{
	g_afktime[id] = 0
}

// // // // // // // // // // // // // // //

public playerSpawned(id) 
{
	g_spawned[id] = false
	new sid[1]
	sid[0] = id
	set_task(0.75, "delayedSpawn",_, sid, 1) // Give the player time to drop to the floor when spawning
}

public delayedSpawn(sid[]) 
{
	get_user_origin(sid[0], g_oldangles[sid[0]])
	g_spawned[sid[0]] = true
}

///////////////////////////////////////////////////////////
// 														///
// 		Автор плагина - Leo_[BH] 						///
// 		Делаю, пишу плагины на заказ! 					///
// 		http://vk.com/id64427766 						///
// 		http://vk.com/cs_rain 							///
// 		Skype: bcnl_leon 								///
// 														///
// 		Мой Магазин плагинов: 							///
// 		http://vk.cc/2pSEjN 							///
// 														///
///////////////////////////////////////////////////////////