#include <amxmodx>
#include <amxmisc>

#define PLUGIN "Menu serwerow"
#define VERSION "0.2.1"
#define AUTHOR "Sebul"


#define SERVERS_FILE "servers_list.ini"
#define MAX_SERVERS 32
#define MAX_CHARACTERS 63

new g_servers[MAX_SERVERS][2][MAX_CHARACTERS+1],
	g_number_server,
	cvar_pokaz_ip;

public plugin_init() {
	register_plugin(PLUGIN, VERSION, AUTHOR);

	register_clcmd("say /server", "show_server");
	register_clcmd("say_team /server", "show_server");

	cvar_pokaz_ip = register_cvar("server_show_ip", "1");

	set_task(4.0, "load_servers");
}

public load_servers() {
	new file_serwers[64];
	get_configsdir(file_serwers, 63);
	formatex(file_serwers, 63, "%s/%s", file_serwers, SERVERS_FILE);

	g_number_server = 0;

	new fHandle = fopen(file_serwers, "rt");

	if(fHandle) {
		new data_server[128];

		while(g_number_server<MAX_SERVERS && !feof(fHandle)) {
			fgets(fHandle, data_server, 127);

			if(!data_server[0] || data_server[0] == ' ' || data_server[0] == ';')
				continue;

			if(parse(data_server, g_servers[g_number_server][0], MAX_CHARACTERS, g_servers[g_number_server][1], MAX_CHARACTERS) != 2)
				continue;

			++g_number_server;
		}
		fclose(fHandle);
	}
	else
		log_amx("Не могу соединится с '%s'", file_serwers);
}

public show_server(id) {
	new menu = menu_create("Список серверов:", "show_server_handle");

	for(new i=0,formats[256],pokaz=get_pcvar_num(cvar_pokaz_ip); i<g_number_server; ++i) {
		formatex(formats, 255, "%s%s%s", g_servers[i][0], pokaz ? " - \y" : "", pokaz ? g_servers[i][1] : "");
		menu_additem(menu, formats);
	}
	menu_setprop(menu, MPROP_BACKNAME, "Назад");
	menu_setprop(menu, MPROP_NEXTNAME, "Дальше");
	menu_setprop(menu, MPROP_EXITNAME, "Выход");
	menu_display(id, menu);

	return PLUGIN_HANDLED;
}

public show_server_handle(id, menu, item) {
	if(item == MENU_EXIT) {
		menu_destroy(menu);
		return PLUGIN_HANDLED;
	}
	client_cmd(id,"echo ^"^";^"Connect^" %s", g_servers[item][1]);
	client_cmd(id,"^"connect^"%s", g_servers[item][1]);

	menu_destroy(menu);
	return PLUGIN_HANDLED;
}
